IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EST_PROD_CPL_DEMANDA_PARAMETRO_EST_MC]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[EST_PROD_CPL_DEMANDA_PARAMETRO_EST_MC](
	[CD_CTR_DEMANDA_PARAMETRO] [int] NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_MC] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
	[CD_USU] [int] NOT NULL,
	[PERC_VARIACAO] [money] NOT NULL,
 CONSTRAINT [PK_EST_PROD_CPL_DEMANDA_PARAMETRO_EST_MC] PRIMARY KEY CLUSTERED 
(
	[CD_CTR_DEMANDA_PARAMETRO] ASC,
	[CD_EMP] ASC,
	[CD_MC] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_PROD_CPL_DEMANDA_PARAMETRO_EST_MC] ADD  CONSTRAINT [DF_EST_PROD_CPL_DEMANDA_PARAMETRO_EST_MC_CD_CTR_DEMANDA_PARAMETRO]  DEFAULT ((0)) FOR [CD_CTR_DEMANDA_PARAMETRO]

ALTER TABLE [dbo].[EST_PROD_CPL_DEMANDA_PARAMETRO_EST_MC] ADD  CONSTRAINT [DF_EST_PROD_CPL_DEMANDA_PARAMETRO_EST_MC_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_PROD_CPL_DEMANDA_PARAMETRO_EST_MC] ADD  CONSTRAINT [DF_EST_PROD_CPL_DEMANDA_PARAMETRO_EST_MC_CD_MC]  DEFAULT ((0)) FOR [CD_MC]

ALTER TABLE [dbo].[EST_PROD_CPL_DEMANDA_PARAMETRO_EST_MC] ADD  CONSTRAINT [DF_EST_PROD_CPL_DEMANDA_PARAMETRO_EST_MC_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]

ALTER TABLE [dbo].[EST_PROD_CPL_DEMANDA_PARAMETRO_EST_MC] ADD  CONSTRAINT [DF_EST_PROD_CPL_DEMANDA_PARAMETRO_EST_MC_CD_USU]  DEFAULT ((0)) FOR [CD_USU]

ALTER TABLE [dbo].[EST_PROD_CPL_DEMANDA_PARAMETRO_EST_MC] ADD  CONSTRAINT [DF_EST_PROD_CPL_DEMANDA_PARAMETRO_EST_MC_PERC_VARIACAO]  DEFAULT ((0)) FOR [PERC_VARIACAO]

ALTER TABLE [dbo].[EST_PROD_CPL_DEMANDA_PARAMETRO_EST_MC]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_CPL_DEMANDA_PARAMETRO_EST_MC_EST_MC] FOREIGN KEY([CD_EMP], [CD_MC])
REFERENCES [dbo].[EST_MC] ([CD_EMP], [CD_MC])

ALTER TABLE [dbo].[EST_PROD_CPL_DEMANDA_PARAMETRO_EST_MC] CHECK CONSTRAINT [FK_EST_PROD_CPL_DEMANDA_PARAMETRO_EST_MC_EST_MC]

ALTER TABLE [dbo].[EST_PROD_CPL_DEMANDA_PARAMETRO_EST_MC]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_CPL_DEMANDA_PARAMETRO_EST_MC_EST_PROD_CPL_DEMANDA_PARAMETRO] FOREIGN KEY([CD_CTR_DEMANDA_PARAMETRO])
REFERENCES [dbo].[EST_PROD_CPL_DEMANDA_PARAMETRO] ([CD_CTR])

ALTER TABLE [dbo].[EST_PROD_CPL_DEMANDA_PARAMETRO_EST_MC] CHECK CONSTRAINT [FK_EST_PROD_CPL_DEMANDA_PARAMETRO_EST_MC_EST_PROD_CPL_DEMANDA_PARAMETRO]
END